/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef B_NTINTR_H_INCLUDED
#define B_NTINTR_H_INCLUDED

#ifndef NO_DDK
#include <ntddk.h>
#include <string.h>
#include <devioctl.h>
#define DDK_INCLUDED
#endif

#define E2925A_DEVICE_ID  0x2925
#define HP_VENDOR_ID      0x103c


#define INTA_INDEX        0
#define INTB_INDEX        1
#define INTC_INDEX        2
#define INTD_INDEX        3

#define INTA_PIN          0x01
#define INTB_PIN          0x02
#define INTC_PIN          0x04
#define INTD_PIN          0x08

#define PROCESSOR_0       0
#define PROCESSOR_1       1
#define PROCESSOR_2       2
#define PROCESSOR_3       3
#define PROCESSOR_OTHER   4
#define PROCESSOR_COUNT   5


/* the size of the following structure has to be a multiple of 4 because
   it may be dumped directly into the result buffer of the E2925A
*/

struct INTR_RESULT_OUT {
    ULONG   ServiceCount [4] [PROCESSOR_COUNT];
};

typedef struct INTR_RESULT_OUT INTR_RESULT_OUT, *PINTR_RESULT_OUT;


struct INTR_DEFCONNECT_IN {
    ULONG   CancelStrategy,
            DwellingTime;
};

typedef struct INTR_DEFCONNECT_IN INTR_DEFCONNECT_IN, *PINTR_DEFCONNECT_IN;


struct INTR_ROUTE_INFO {
    UCHAR   Pin,
            Level;
};

typedef struct INTR_ROUTE_INFO INTR_ROUTE_INFO, *PINTR_ROUTE_INFO;


/* Define the IOCTL codes we will use.  The IOCTL code contains a command */
/* identifier, plus other information about the device, the type of access */
/* with which the file must have been opened, and the type of buffering. */

/* Device type           -- in the "User Defined" range." */

#define NTIO_TYPE_INTR 43000
/* this IOCTLs are for the Intr driver */

#define IOCTL_INTR_RESULT_GET \
    CTL_CODE( NTIO_TYPE_INTR, 0x960, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_INTR_CONNECT_INTR \
    CTL_CODE( NTIO_TYPE_INTR, 0x962, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_INTR_DISCONNECT_INTR \
    CTL_CODE( NTIO_TYPE_INTR, 0x964, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_INTR_DEFCONNECT_INTR \
    CTL_CODE( NTIO_TYPE_INTR, 0x966, METHOD_BUFFERED, FILE_ANY_ACCESS )
    /* IN:  INTR_DEFCONNECT_IN
       OUT: INTR_ROUTE_INFO */

#define IOCTL_INTR_DEFDISCONNECT_INTR \
    CTL_CODE( NTIO_TYPE_INTR, 0x968, METHOD_BUFFERED, FILE_ANY_ACCESS )
    /* IN:  --
       OUT: -- */

#define IOCTL_INTR_SLOT_NUMBER \
    CTL_CODE( NTIO_TYPE_INTR, 0x96A, METHOD_BUFFERED, FILE_ANY_ACCESS )
    /* IN:  PCI_SLOT_NUMBER in Best format,   (ULONG)
       OUT: -- */

#define IOCTL_INTR_RESET_INTR \
    CTL_CODE( NTIO_TYPE_INTR, 0x96C, METHOD_BUFFERED, FILE_ANY_ACCESS )
    /* IN:  --
       OUT: -- */

/* registry path for device map */
#define HPBEST_DEVICES_PATH  L"HPBEST_DEVICES"

/* NT device name */
#define NTIO_DEVICE_NAME_INTR L"\\Device\\BestNTIntr"

/* symbolic links for CreateFile */
#define DOS_DEVICE_NAME_INTR  L"\\DosDevices\\BestNTIntr"


#ifndef NO_DDK

struct GENISRCONTEXT {
	PDEVICE_OBJECT		DeviceObject;
    BOOLEAN             IsConnected;
    PKINTERRUPT	        InterruptObject;
	UCHAR				IntrPin;
};

typedef struct GENISRCONTEXT GENISRCONTEXT, *PGENISRCONTEXT;


struct ISRCONTEXT {
	GENISRCONTEXT		isr;
	ULONG				CancelStrategy,
						DwellingTime;
    ULONG               ServiceCount [PROCESSOR_COUNT];
};

typedef struct ISRCONTEXT ISRCONTEXT, *PISRCONTEXT;


/* driver local data structure specific to each device object */
typedef struct _LOCAL_DEVICE_INFO {
    PDEVICE_OBJECT      DeviceObject;          /* The BestNTio device object. */
	PCI_SLOT_NUMBER     PCISlot;
    ULONG               BusNumber;
	PUCHAR				IOAddr;
    LARGE_INTEGER       LoopsPerSecond;
	ISRCONTEXT          IsrContext [4];        /* one object for each interrupt line */
} LOCAL_DEVICE_INFO, *PLOCAL_DEVICE_INFO;


/********************* function prototypes ***********************************/
/* */

NTSTATUS    DriverEntry(       IN  PDRIVER_OBJECT DriverObject,
                               IN  PUNICODE_STRING RegistryPath );

NTSTATUS    NTIntrDispatch(      IN  PDEVICE_OBJECT pDO,
                               IN  PIRP pIrp                    );

NTSTATUS    NTIntrOpen(          IN  PDEVICE_OBJECT pDO,
                               IN  PIRP pIrp                    );

NTSTATUS    NTIntrClose(         IN  PDEVICE_OBJECT pDO,
                               IN  PIRP pIrp                    );

VOID        NTIntrUnload(        IN  PDRIVER_OBJECT DriverObject );


NTSTATUS NTIntrWrite(
		     PDEVICE_OBJECT pDeviceObject,
		     PIRP           pIrp
		     );

NTSTATUS NTIntrRead(
		    PDEVICE_OBJECT DeviceObject,
		    PIRP           Irp
		    );


NTSTATUS NTIntrIoctl(
		     IN PLOCAL_DEVICE_INFO pLDI,
		     IN PIRP pIrp,
		     IN PIO_STACK_LOCATION IrpStack );


BOOLEAN BestIntrService(
			IN PKINTERRUPT Interrupt,
			IN OUT PVOID Context
			);


BOOLEAN IntrtestISR(
			IN PKINTERRUPT Interrupt,
			IN OUT PVOID Context
			);


NTSTATUS ConnectInterrupt (
            PGENISRCONTEXT      pCtx,
            PKSERVICE_ROUTINE   Isr,
            ULONG               BusNumber,
            ULONG               InterruptLevel
            );

#endif
#endif



